import * as tslib_1 from "tslib";
import { EventEmitter } from 'scilla';
import { StackNavigator } from "./StackNavigator";
var showLog = false;
export var VIEW_WILL_ENTER = 'VIEW_WILL_ENTER';
export var VIEW_DID_ENTER = 'VIEW_DID_ENTER';
export var VIEW_WILL_LEAVE = 'VIEW_WILL_LEAVE';
export var VIEW_DID_LEAVE = 'VIEW_DID_LEAVE';
var VirtualNavigator = (function (_super) {
    tslib_1.__extends(VirtualNavigator, _super);
    function VirtualNavigator(container) {
        var _this = _super.call(this) || this;
        _this._container = container;
        _this._classDic = {};
        _this.stack = new StackNavigator(_this);
        return _this;
    }
    VirtualNavigator.prototype.register = function (alias, childName, componentDef) {
        this._classDic[alias] = {
            childName: childName,
            componentDef: componentDef,
        };
    };
    Object.defineProperty(VirtualNavigator.prototype, "currentView", {
        get: function () {
            return this._currentView;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VirtualNavigator.prototype, "currentName", {
        get: function () {
            return this._currentName;
        },
        enumerable: true,
        configurable: true
    });
    VirtualNavigator.prototype.getViewInstanceByName = function (name) {
        var _a = this._classDic[name], childName = _a.childName, componentDef = _a.componentDef;
        var scene = this._container.getChildrenByName(childName)[0];
        var component = scene.getComponent(componentDef);
        return component;
    };
    VirtualNavigator.prototype.onEnter = function (name, last, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        this._currentView = view;
                        this._currentName = name;
                        return [4, view.onWillMount(last, action, parameters)];
                    case 1:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' will enter.');
                        this.emit(VIEW_WILL_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        return [4, view.onWillEnter(last, action, parameters)];
                    case 2:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' did enter.');
                        this.emit(VIEW_DID_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        view.onDidEnter(last, action, parameters);
                        return [2];
                }
            });
        });
    };
    VirtualNavigator.prototype.onLeave = function (name, next, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        return [4, view.onWillUnMount(name, action, parameters)];
                    case 1:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' will leave.');
                        this.emit(VIEW_WILL_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        return [4, view.onWillLeave(next, action, parameters)];
                    case 2:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' did leave.');
                        this.emit(VIEW_DID_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        view.onDidLeave(next, action, parameters);
                        return [2];
                }
            });
        });
    };
    VirtualNavigator.prototype.onError = function (error) {
    };
    return VirtualNavigator;
}(EventEmitter));
export { VirtualNavigator };
//# sourceMappingURL=module.js.map