import * as tslib_1 from "tslib";
import { VirtualNavigator } from "./VirtualNavigator";
import { SceneStart, ScenePlay } from "../scenes";
import ScillaComponent from "components/base/ScillaComponent";
var SingleSceneNavigator = (function (_super) {
    tslib_1.__extends(SingleSceneNavigator, _super);
    function SingleSceneNavigator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SingleSceneNavigator.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._navigator = new VirtualNavigator(this.entity);
        this._navigator.register('start', 'SceneStart', SceneStart);
        this._navigator.register('play', 'ScenePlay', ScenePlay);
        this.push('start');
    };
    SingleSceneNavigator.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    SingleSceneNavigator.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    SingleSceneNavigator.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    SingleSceneNavigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.push(name, parameters);
    };
    SingleSceneNavigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.pop(parameters);
    };
    SingleSceneNavigator.prototype.popToBottom = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.popTo(0, null, parameters);
    };
    SingleSceneNavigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.popAll(name, parameters);
    };
    SingleSceneNavigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.replace(name, parameters);
    };
    SingleSceneNavigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.jump(name, parameters);
    };
    return SingleSceneNavigator;
}(ScillaComponent));
export default SingleSceneNavigator;
//# sourceMappingURL=module.js.map