import * as tslib_1 from "tslib";
import { EventEmitter } from 'scilla';
import { StackNavigator } from "./StackNavigator";
var showLog = false;
var Navigator = (function (_super) {
    tslib_1.__extends(Navigator, _super);
    function Navigator() {
        var _this = _super.call(this) || this;
        _this._classDic = {};
        _this._instanceDic = {};
        _this.stack = new StackNavigator(_this);
        return _this;
    }
    Navigator.prototype.register = function (name, clazz) {
        this._classDic[name] = clazz;
    };
    Navigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.push(name, parameters);
    };
    Navigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.pop(parameters);
    };
    Navigator.prototype.popToBottom = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.popTo(0, null, parameters);
    };
    Navigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.popAll(name, parameters);
    };
    Navigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.replace(name, parameters);
    };
    Navigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.jump(name, parameters);
    };
    Object.defineProperty(Navigator.prototype, "currentView", {
        get: function () {
            return this._currentView;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Navigator.prototype, "currentName", {
        get: function () {
            return this._currentName;
        },
        enumerable: true,
        configurable: true
    });
    Navigator.prototype.newView = function (name) {
        return new this._classDic[name]();
    };
    Navigator.prototype.getViewInstanceByName = function (name) {
        var view = this._instanceDic[name];
        if (!view) {
            view = this._instanceDic[name] = this.newView(name);
        }
        return view;
    };
    Navigator.prototype.addView = function (view, addToBottom) {
    };
    Navigator.prototype.onEnter = function (name, last, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view, addToBottom;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        this._currentView = view;
                        this._currentName = name;
                        return [4, view.onWillMount(last, action, parameters)];
                    case 1:
                        _a.sent();
                        addToBottom = view.onAddView();
                        this.addView(view, addToBottom);
                        if (showLog)
                            console.log(name + ' will enter.');
                        this.emit(Navigator.VIEW_WILL_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        return [4, view.onWillEnter(last, action, parameters)];
                    case 2:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' did enter.');
                        this.emit(Navigator.VIEW_DID_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        view.onDidEnter(last, action, parameters);
                        return [2];
                }
            });
        });
    };
    Navigator.prototype.onLeave = function (name, next, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        return [4, view.onWillUnMount(name, action, parameters)];
                    case 1:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' will leave.');
                        this.emit(Navigator.VIEW_WILL_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        return [4, view.onWillLeave(next, action, parameters)];
                    case 2:
                        _a.sent();
                        if (showLog)
                            console.log(name + ' did leave.');
                        this.emit(Navigator.VIEW_DID_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        view.onDidLeave(next, action, parameters);
                        return [2];
                }
            });
        });
    };
    Navigator.prototype.onError = function (error) {
    };
    Navigator.VIEW_WILL_ENTER = 'VIEW_WILL_ENTER';
    Navigator.VIEW_DID_ENTER = 'VIEW_DID_ENTER';
    Navigator.VIEW_WILL_LEAVE = 'VIEW_WILL_LEAVE';
    Navigator.VIEW_DID_LEAVE = 'VIEW_DID_LEAVE';
    return Navigator;
}(EventEmitter));
export { Navigator };
//# sourceMappingURL=module.js.map