import { engine } from "scilla";
export function renderRunCredits(v) {
    var unitName = engine.dataCenter.get('CFG', 'unitName');
    return Math.floor(v) + unitName;
}
export function htmlSimplify(html) {
    var content = html
        .replace(/<\/\w+><\w+>/ig, '\n')
        .replace(/<\w+>/ig, '\n')
        .replace(/<\/\w+>/ig, '\n')
        .replace(/<\w+\/>/ig, '\n')
        .replace('&nbsp;', '');
    content = content.trim();
    return content;
}
export function isWeiXin() {
    var ua = window.navigator.userAgent.toLowerCase();
    return ua.includes('micromessenger');
}
export function stringFixed(str, limit, mask) {
    if (limit === void 0) { limit = 6; }
    if (mask === void 0) { mask = '…'; }
    if (str.length > limit) {
        return str.substr(0, limit) + mask;
    }
    return str;
}
//# sourceMappingURL=module.js.map