import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease } from "scilla";
import TextRenderer from "components/renderer/TextRenderer";
var TimesCard = (function (_super) {
    tslib_1.__extends(TimesCard, _super);
    function TimesCard() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TimesCard.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._labelRenderer = this.Label.getComponent(TextRenderer);
    };
    TimesCard.prototype.setTimes = function (v) {
        this._labelRenderer.text = 'X' + v;
    };
    TimesCard.prototype.playShow = function (v) {
        var _this = this;
        if (v !== undefined) {
            this.setTimes(v);
        }
        this.entity.enabled = true;
        return new Promise(function (resolve) {
            createTween(_this, _this.transform, true)
                .set({ scale: { x: 2, y: 2 }, alpha: 0 }, true)
                .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, ease.backOut)
                .wait(500)
                .to({ alpha: 0 }, 500)
                .call(resolve);
        });
    };
    return TimesCard;
}(ScillaComponent));
export default TimesCard;
//# sourceMappingURL=module.js.map