import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease, engine } from "scilla";
import Transform from "components/base/Transform";
import TextRenderer from "components/renderer/TextRenderer";
import RunNumber from "../common/RunNumber";
import { renderRunCredits, stringFixed } from "./utils";
import Zoom from "components/animation/Zoom";
import TextureRenderer from "components/renderer/TextureRenderer";
var PKResultSide = (function (_super) {
    tslib_1.__extends(PKResultSide, _super);
    function PKResultSide() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResultSide.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._labelName = this.LabelName.getComponent(TextRenderer);
        this._labelCredits = this.LabelCredits.getComponent(TextRenderer);
        this._labelCreditsTransform = this.LabelCredits.getComponent(Transform);
        this._resultTagRenderer = this.ResultTag.getComponent(TextureRenderer);
        this._bodyRenderer = this.Body.getComponent(TextureRenderer);
        this._resultTagZoom = this.ResultTag.getComponent(Zoom);
        this._labelRunCredits = this.LabelCredits.getComponent(RunNumber);
        this._labelRunCredits.$renderFunc = renderRunCredits;
        this._pos = this.transform.position.x;
    };
    PKResultSide.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    PKResultSide.prototype.play = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var nickname, finalCredits, otherFinalCredits, resultState, win, stageWidth, toValue_1;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        nickname = data.nickname, finalCredits = data.finalCredits, otherFinalCredits = data.otherFinalCredits, resultState = data.resultState;
                        this._labelName.text = stringFixed(nickname);
                        this._labelCredits.text = renderRunCredits(finalCredits);
                        win = resultState === this.side;
                        this._bodyRenderer.texture = resultState === 0 || win ? this.winBodyRes : this.loseBodyRes;
                        this.ResultTag.enabled = false;
                        this.Stars.enabled = false;
                        stageWidth = engine.renderContext.stageSize.width;
                        return [4, createTween(this, this.transform.position)
                                .set({ x: stageWidth * this.side }, true)
                                .to({ x: this._pos }, 300, ease.cubicOut)
                                .getPromise()];
                    case 1:
                        _a.sent();
                        this._labelCreditsTransform.scale.setXY(1, 1);
                        this._resultTagRenderer.texture = resultState === 0 ? this.equalTagRes : (win ? this.winTagRes : this.loseTagRes);
                        setTimeout(function () {
                            _this.ResultTag.enabled = true;
                            if (win) {
                                _this.Stars.enabled = true;
                            }
                        }, 300);
                        if (!(resultState === 0)) return [3, 2];
                        return [3, 4];
                    case 2:
                        toValue_1 = win ? finalCredits + otherFinalCredits : 0;
                        return [4, createTween(this, this._labelCreditsTransform)
                                .wait(1000)
                                .call(function () {
                                _this._labelRunCredits.play(toValue_1);
                            })
                                .to({ scale: win ? { x: 1.4, y: 1.4 } : { x: 0.6, y: 0.6 } }, 1000)
                                .getPromise()];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4: return [2];
                }
            });
        });
    };
    return PKResultSide;
}(ScillaComponent));
export default PKResultSide;
//# sourceMappingURL=module.js.map