import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease, engine } from "scilla";
import Transform from "components/base/Transform";
import TextRenderer from "components/renderer/TextRenderer";
import TimesCard from "./TimesCard";
import RunNumber from "../common/RunNumber";
import { renderRunCredits, stringFixed } from "./utils";
var PKResultAnimSide = (function (_super) {
    tslib_1.__extends(PKResultAnimSide, _super);
    function PKResultAnimSide() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResultAnimSide.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._labelName = this.LabelName.getComponent(TextRenderer);
        this._labelCredits = this.LabelCredits.getComponent(TextRenderer);
        this._labelCreditsTransform = this.LabelCredits.getComponent(Transform);
        this._labelRunCredits = this.LabelCredits.getComponent(RunNumber);
        this._timesCard = this.TimesCard.getComponent(TimesCard);
        this._labelRunCredits.$renderFunc = renderRunCredits;
        this._pos = this.transform.position.x;
    };
    PKResultAnimSide.prototype.play = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var nickname, receiveCredits, finalCredits, multipleCard, showTimesCard, toScale1, toScale2, stageWidth;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        nickname = data.nickname, receiveCredits = data.receiveCredits, finalCredits = data.finalCredits, multipleCard = data.multipleCard;
                        showTimesCard = multipleCard > 0;
                        this._labelName.text = stringFixed(nickname);
                        this._labelCredits.text = '';
                        this.TimesCard.enabled = false;
                        this._labelCreditsTransform.scale.setXY(0.6, 0.6);
                        toScale1 = {
                            x: 1, y: 1,
                        };
                        toScale2 = {
                            x: 1.4, y: 1.4,
                        };
                        stageWidth = engine.renderContext.stageSize.width;
                        return [4, createTween(this, this.transform.position)
                                .set({ x: stageWidth * this.side }, true)
                                .to({ x: this._pos }, 500, ease.backOut)
                                .getPromise()];
                    case 1:
                        _a.sent();
                        createTween(this, this._labelCreditsTransform)
                            .to({ scale: showTimesCard ? toScale1 : toScale2 }, 1000);
                        return [4, this._labelRunCredits.play(receiveCredits, 0)];
                    case 2:
                        _a.sent();
                        if (!showTimesCard) return [3, 5];
                        return [4, this._timesCard.playShow(multipleCard)];
                    case 3:
                        _a.sent();
                        createTween(this, this._labelCreditsTransform)
                            .to({ scale: toScale2 }, 1000);
                        return [4, this._labelRunCredits.play(finalCredits, receiveCredits)];
                    case 4:
                        _a.sent();
                        _a.label = 5;
                    case 5: return [2];
                }
            });
        });
    };
    return PKResultAnimSide;
}(ScillaComponent));
export default PKResultAnimSide;
//# sourceMappingURL=module.js.map