import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import LabelCarousel from '../common/LabelCarousel';
import RectRenderer from "components/renderer/RectRenderer";
var NoticeBar = (function (_super) {
    tslib_1.__extends(NoticeBar, _super);
    function NoticeBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._pool = [];
        _this.getTextFunc = function () {
            if (_this._pool.length < 5) {
                _this.initGameStage();
            }
            if (_this._pool.length > 0) {
                if (_this._pool.length > 0) {
                    _this._bgRenderer.enabled = true;
                }
                return _this._pool.shift();
            }
        };
        return _this;
    }
    NoticeBar.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._bgRenderer = this.getComponent(RectRenderer);
        this._bgRenderer.enabled = false;
        this._labelCarousel = this.getComponent(LabelCarousel);
        this._labelCarousel.getTextFunc = this.getTextFunc;
    };
    NoticeBar.prototype.initGameStage = function () {
        this.broadcast('callApi', 1, 'noticeContent', { opActivityId: this.opActivityId });
    };
    NoticeBar.prototype.onGotNoticeContent = function (response) {
        this._pool = this._pool.concat(response);
        if (!this._labelCarousel._playing) {
            this._labelCarousel.play();
        }
    };
    return NoticeBar;
}(ScillaComponent));
export default NoticeBar;
//# sourceMappingURL=module.js.map