import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import FrameAnimationRenderer from "components/renderer/FrameAnimationRenderer";
import { createTween, ease, instantiate, Vector2D } from "scilla";
import Hole from "./Hole";
import Transform from "components/base/Transform";
var speed = new Vector2D(2.5, 2.5);
var walkRange = 750 / 2 - 50;
var STATUS;
(function (STATUS) {
    STATUS[STATUS["IDLE"] = 0] = "IDLE";
    STATUS[STATUS["WALK"] = 1] = "WALK";
    STATUS[STATUS["DIG"] = 2] = "DIG";
    STATUS[STATUS["DIG_IDLE"] = 3] = "DIG_IDLE";
})(STATUS || (STATUS = {}));
var Miner = (function (_super) {
    tslib_1.__extends(Miner, _super);
    function Miner() {
        var _this = _super.call(this) || this;
        _this.itemGap = new Vector2D(5, -1);
        _this.smallItemScale = new Vector2D(0.3, 0.3);
        _this._velocity = new Vector2D();
        _this._diggingHole = false;
        _this._itemCount = 0;
        _this._status = STATUS.IDLE;
        return _this;
    }
    Miner.prototype.prepare = function (digDelegate, maxDepth, resName) {
        this._digDelegate = digDelegate;
        this._maxDepth = maxDepth;
        this._bodyAnim.frameAnimation = this.animations[resName];
    };
    Miner.prototype.reset = function () {
        var e_1, _a;
        try {
            for (var _b = tslib_1.__values(this.Items.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                item.enabled = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._itemCount = 0;
        this._avoidPosition = null;
        this._hole.hide();
        this._minerTransform.position.y = 0;
    };
    Miner.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._minerTransform = this.Miner.getComponent(Transform);
        this._bodyAnim = this.Body.getComponent(FrameAnimationRenderer);
        this._effectAnim = this.Effect.getComponent(FrameAnimationRenderer);
        this._hole = this.Hole.getComponent(Hole);
        this._hole.hide();
    };
    Miner.prototype.onUpdate = function (t) {
        var e_2, _a;
        _super.prototype.onUpdate.call(this, t);
        var _b = this, minerPosition = _b._minerTransform.position, position = _b.transform.position, _velocity = _b._velocity;
        switch (this._status) {
            case STATUS.IDLE:
                break;
            case STATUS.WALK:
                position.x += _velocity.x;
                if (Math.abs(position.x) > walkRange) {
                    _velocity.x = -_velocity.x;
                    this.dir = _velocity.x >= 0 ? 1 : -1;
                }
                if (this._avoidPosition && Math.abs(position.x - this._avoidPosition.x) > this.holeRes.width) {
                    this.playDig();
                }
                break;
            case STATUS.DIG:
                if (this._diggingHole) {
                    minerPosition.y += _velocity.y;
                    this._hole.setDeep(minerPosition.y - 25);
                    var items = this._digDelegate(position.x, minerPosition.y - 50);
                    if (items.length > 0) {
                        this.playDigIdle();
                    }
                    try {
                        for (var items_1 = tslib_1.__values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                            var item = items_1_1.value;
                            this.playAddItem(item);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    if (minerPosition.y > this._maxDepth) {
                        this.playIdle();
                        this.bubbling('digEnd');
                    }
                }
                break;
            case STATUS.DIG_IDLE:
                break;
        }
    };
    Object.defineProperty(Miner.prototype, "dir", {
        get: function () {
            return this._minerTransform.scale.x;
        },
        set: function (v) {
            this._minerTransform.scale.x = v;
        },
        enumerable: true,
        configurable: true
    });
    Miner.prototype.standSide = function (dir) {
        this.transform.position.x = walkRange * -dir;
        this.dir = dir;
    };
    Miner.prototype.playIdle = function () {
        this._status = STATUS.IDLE;
        this._bodyAnim.play('idle', -1);
    };
    Miner.prototype.playWalk = function () {
        this._status = STATUS.WALK;
        this._diggingHole = false;
        this._bodyAnim.play('walk', -1);
        this._velocity.x = speed.x;
        this.dir = 1;
    };
    Miner.prototype.playDig = function () {
        this._bodyAnim.play('beginDig', 1);
        this._status = STATUS.DIG;
        this._velocity.setXY(0, speed.y);
    };
    Miner.prototype.playDigIdle = function () {
        this._bodyAnim.play('idle', -1);
        this._status = STATUS.DIG_IDLE;
        this._velocity.y = 0;
    };
    Miner.prototype.playAddItem = function (item) {
        var e_3, _a;
        var _this = this;
        var target;
        try {
            for (var _b = tslib_1.__values(this.Items.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item_1 = _c.value;
                if (!item_1.enabled) {
                    target = item_1;
                    target.enabled = true;
                    break;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (!target) {
            target = instantiate(this.itemHangPrefab);
            this.Items.addChild(target);
        }
        item.exclude = true;
        item.entity.enabled = false;
        var pos = item.getComponent(Transform).globalPosition;
        var targetTransform = target.getComponent(Transform);
        var localPos = this.Items.getComponent(Transform).globalPositionToLocal(pos);
        targetTransform.position.copyFrom(localPos);
        targetTransform.scale.setXY(1, 1);
        var position = { x: this._itemCount * this.itemGap.x, y: this._itemCount * this.itemGap.y };
        this._itemCount++;
        createTween(this, targetTransform, false, { fields: ['x', 'y'] })
            .to({ position: position, scale: this.smallItemScale.toObj() }, 500, ease.cubicInOut)
            .call(function () {
            _this.playDig();
        });
    };
    Miner.prototype.onAnimationComplete = function (label) {
        switch (label) {
            case 'beginDig':
                this._bodyAnim.play('dig', -1);
                this._effectAnim.play(0, 1);
                this._hole.show();
                this._diggingHole = true;
                break;
        }
    };
    Miner.prototype.onAnimationLoopComplete = function (label) {
        switch (label) {
            case 'dig':
                this._effectAnim.play(0, 1);
                break;
        }
    };
    Miner.prototype.avoidToDig = function (position) {
        var _this = this;
        setTimeout(function () {
            _this._avoidPosition = position;
        }, Math.random() * 500 + 500);
    };
    return Miner;
}(ScillaComponent));
export default Miner;
//# sourceMappingURL=module.js.map