import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { instantiate, engine } from "scilla";
import Miner from "./Miner";
import BottomButtonController from "./BottomButtonController";
import CountDown from "../common/CountDown";
import ItemLayer from "./ItemLayer";
import globalEvent from "globalEvent";
var minerConfigs = [
    { res: 'blue', dir: 1, walk: true },
    { res: 'red', dir: -1, walk: false },
];
var GameStage = (function (_super) {
    tslib_1.__extends(GameStage, _super);
    function GameStage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._miners = [];
        _this.matchResult = function (action) {
            if (action === 'close') {
                _this._bottomButtonController.enableAll();
                _this.broadcast('abortCallApi', 1, 'getOrderStatus');
            }
            else {
                _this.startPKDig();
            }
        };
        _this.onPKResult = function (action) {
            _this.reset();
            if (action === 'retry') {
                _this.onTapPK();
            }
        };
        _this.onSingleResultComplete = function () {
            _this.reset();
        };
        _this.onPKChallengeClose = function (action) {
            if (action === 'accept') {
                _this.onTapPK(1);
            }
        };
        return _this;
    }
    GameStage.prototype.onCreate = function () {
        var e_1, _a;
        _super.prototype.onCreate.call(this);
        this._bottomButtonController = this.Bottom.getComponent(BottomButtonController);
        this._countdown = this.CountDown.getComponent(CountDown);
        this._itemLayer = this.ItemLayer.getComponent(ItemLayer);
        try {
            for (var minerConfigs_1 = tslib_1.__values(minerConfigs), minerConfigs_1_1 = minerConfigs_1.next(); !minerConfigs_1_1.done; minerConfigs_1_1 = minerConfigs_1.next()) {
                var config = minerConfigs_1_1.value;
                var minerEntity = instantiate(this.minerPrefab);
                this.MinerLayer.addChild(minerEntity);
                var miner = minerEntity.getComponent(Miner);
                miner.prepare(this._itemLayer.digDelegate, this.holeRes.height - 40, config.res);
                this._miners.push(miner);
                minerEntity.enabled = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (minerConfigs_1_1 && !minerConfigs_1_1.done && (_a = minerConfigs_1.return)) _a.call(minerConfigs_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    GameStage.prototype.initGameStage = function () {
        this.reset();
        if (this.activityBaseInfo.machineNickname) {
            this.bubbling('showDialog', 'PKChallenge', null, this.onPKChallengeClose);
        }
    };
    GameStage.prototype.reset = function () {
        var e_2, _a;
        try {
            for (var _b = tslib_1.__values(this._miners), _c = _b.next(); !_c.done; _c = _b.next()) {
                var miner = _c.value;
                miner.entity.enabled = false;
                miner.reset();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this._itemLayer.prepareItems();
        this.resetBottomButton();
        var selfMiner = this._miners[0];
        selfMiner.entity.enabled = true;
        selfMiner.standSide(1);
        selfMiner.playWalk();
    };
    GameStage.prototype.resetBottomButton = function () {
        this._bottomButtonController.switchState(false);
        this._bottomButtonController.enableAll();
    };
    GameStage.prototype.loginAlert = function () {
        if (!this.isLogin) {
            this.bubbling('showLoginAlert');
        }
        return this.isLogin;
    };
    GameStage.prototype.creditsAlert = function () {
        return true;
    };
    GameStage.prototype.onTapDig = function () {
        if (!this.loginAlert() || !this.creditsAlert()) {
            return;
        }
        this._bottomButtonController.disableAll();
        this._orderStatus = 0;
        this._digFinishedCount = 0;
        this._minerCount = 1;
        var opActivityId = engine.dataCenter.get('CFG', 'opActivityId');
        this.broadcast('callApi', 1, 'singleDigData', { opActivityId: opActivityId });
    };
    GameStage.prototype.onTapPK = function (channel) {
        if (channel === void 0) { channel = 0; }
        if (!this.loginAlert() || !this.creditsAlert()) {
            return;
        }
        this._bottomButtonController.disableAll();
        this._orderStatus = 0;
        this._digFinishedCount = 0;
        this._minerCount = 2;
        var opActivityId = engine.dataCenter.get('CFG', 'opActivityId');
        this.broadcast('callApi', 1, 'pkDigData', { opActivityId: opActivityId }, channel);
    };
    GameStage.prototype.changeOrderStatus = function (v) {
        this._orderStatus = v;
        this.checkDigEnd();
    };
    GameStage.prototype.readyDig = function (minerCount, channel) {
        if (minerCount === 1) {
            this.startDig(minerCount);
        }
        else {
            if (channel === 1) {
                this.pkDigData.machineNickname = this.activityBaseInfo.machineNickname;
            }
            this.bubbling('hideAllDialog');
            this.bubbling('showDialog', 'PKMatching', { channel: channel }, this.matchResult);
        }
        this.activityBaseInfo.curCredits -= minerCount === 1 ? this.activityBaseInfo.miningExpend : this.activityBaseInfo.pkExpend;
        globalEvent.emit('runCredits', 500);
        this._itemLayer.stopCreditsAnimation();
    };
    GameStage.prototype.startDig = function (minerCount) {
        var _a = this, _miners = _a._miners, _countdown = _a._countdown;
        _countdown.stop();
        var selfMiner = _miners[0];
        selfMiner.playDig();
        if (minerCount === 1) {
        }
        else {
            this._bottomButtonController.disablePkDigButton();
            var otherMiner = _miners[1];
            otherMiner.avoidToDig(selfMiner.transform.position);
        }
    };
    GameStage.prototype.startPKDig = function () {
        this._bottomButtonController.switchState(true);
        this._countdown.play();
        for (var i = 0, li = minerConfigs.length; i < li; i++) {
            var config = minerConfigs[i];
            var miner = this._miners[i];
            miner.entity.enabled = true;
            miner.standSide(config.dir);
            miner.playWalk();
        }
    };
    GameStage.prototype.restoreDig = function (e) {
        this.reset();
    };
    GameStage.prototype.checkDigEnd = function () {
        if (this._orderStatus !== 0 && this._digFinishedCount === this._minerCount) {
            switch (this._orderStatus) {
                case 2:
                case 4:
                    this.onDigEnd();
                    break;
                case 1:
                case 3:
                    this.bubbling('showNetError');
                    break;
            }
        }
    };
    GameStage.prototype.digEnd = function () {
        this._digFinishedCount++;
        this.checkDigEnd();
    };
    GameStage.prototype.onDigEnd = function () {
        switch (this._minerCount) {
            case 1:
                this.activityBaseInfo.curCredits += this.singleDigData.finalCredits;
                this.activityBaseInfo.heapCredits += this.singleDigData.finalCredits;
                this.bubbling('hideAllDialog');
                this.bubbling('showDialog', 'SingleResult', null, this.onSingleResultComplete);
                break;
            case 2:
                var _a = this.pkDigData, userFinalCredits = _a.userFinalCredits, machineFinalCredits = _a.machineFinalCredits;
                var resultState = userFinalCredits === machineFinalCredits ? 0 : (userFinalCredits > machineFinalCredits ? -1 : 1);
                this.pkDigData.resultState = resultState;
                var gotCredits = userFinalCredits;
                if (resultState < 0) {
                    gotCredits += machineFinalCredits;
                }
                else if (resultState > 0) {
                    gotCredits = 0;
                }
                this.activityBaseInfo.curCredits += gotCredits;
                this.activityBaseInfo.heapCredits += gotCredits;
                this.bubbling('hideAllDialog');
                this.bubbling('showDialog', 'PKResult', null, this.onPKResult);
                break;
        }
    };
    return GameStage;
}(ScillaComponent));
export default GameStage;
//# sourceMappingURL=module.js.map