import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import TextRenderer from "components/renderer/TextRenderer";
import RunNumber from "../common/RunNumber";
import globalEvent from "globalEvent";
import RectRenderer from "components/renderer/RectRenderer";
var CreditsBar = (function (_super) {
    tslib_1.__extends(CreditsBar, _super);
    function CreditsBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.runDuration = 2000;
        return _this;
    }
    CreditsBar.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        globalEvent.on('runCredits', this.runCredits, this);
        this._bgRenderer = this.getComponent(RectRenderer);
        this._creditsUnitName = this.CreditsUnitName.getComponent(TextRenderer);
        this._labelCreditsCurrent = this.LabelCreditsCurrent.getComponent(TextRenderer);
        this._labelCreditsTotal = this.LabelCreditsTotal.getComponent(TextRenderer);
        this._runCreditsCurrent = this.LabelCreditsCurrent.getComponent(RunNumber);
        this._runCreditsTotal = this.LabelCreditsTotal.getComponent(RunNumber);
        this._creditsUnitName.text = this.unitName;
        if (this.showCredits !== 1) {
            this.LabelCreditsCurrent.enabled = false;
            this.Line.enabled = false;
            this.Label.enabled = false;
        }
        this._bgRenderer.width = this.showCredits === 1 ? 480 : 320;
    };
    CreditsBar.prototype.initGameStage = function () {
        var _a = this.activityBaseInfo, curCredits = _a.curCredits, heapCredits = _a.heapCredits;
        if (this.showCredits === 1) {
            this._labelCreditsCurrent.text = curCredits.toString();
        }
        this._labelCreditsTotal.text = heapCredits.toString();
    };
    CreditsBar.prototype.runCredits = function (duration) {
        var _a = this.activityBaseInfo, curCredits = _a.curCredits, heapCredits = _a.heapCredits;
        if (this.showCredits === 1) {
            this._runCreditsCurrent.duration = duration || this.runDuration;
            this._runCreditsCurrent.play(curCredits);
        }
        this._runCreditsTotal.duration = duration || this.runDuration;
        this._runCreditsTotal.play(heapCredits);
    };
    return CreditsBar;
}(ScillaComponent));
export default CreditsBar;
//# sourceMappingURL=module.js.map