import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease } from "scilla";
import PKResultSide from "../../game/PKResultSide";
import Transform from "components/base/Transform";
import RelativeLayout from "components/other/RelativeLayout";
var ResultLayer = (function (_super) {
    tslib_1.__extends(ResultLayer, _super);
    function ResultLayer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ResultLayer.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._leftSide = this.LeftSide.getComponent(PKResultSide);
        this._rightSide = this.RightSide.getComponent(PKResultSide);
        this._lineTransform = this.Line.getComponent(Transform);
        this._bottomBarLayout = this.BottomBar.getComponent(RelativeLayout);
        this._bottomBarHeight = this.BottomBar.getComponent(Transform).height;
        this.hide();
    };
    ResultLayer.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    ResultLayer.prototype.play = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a, userFinalCredits, machineFinalCredits, machineNickname, resultState;
            var _this = this;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.pkData, userFinalCredits = _a.userFinalCredits, machineFinalCredits = _a.machineFinalCredits, machineNickname = _a.machineNickname, resultState = _a.resultState;
                        createTween(this, this._lineTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 0 }, true)
                            .wait(200)
                            .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, ease.backOut);
                        return [4, Promise.all([this._leftSide.play({
                                    nickname: this.userNickname,
                                    finalCredits: userFinalCredits,
                                    otherFinalCredits: machineFinalCredits,
                                    resultState: resultState
                                }),
                                this._rightSide.play({
                                    nickname: machineNickname,
                                    finalCredits: machineFinalCredits,
                                    otherFinalCredits: userFinalCredits,
                                    resultState: resultState
                                }),]).then(function () {
                                createTween(_this, _this._bottomBarLayout)
                                    .to({ bottom: 0 }, 500, ease.cubicOut);
                            })];
                    case 1:
                        _b.sent();
                        return [2];
                }
            });
        });
    };
    ResultLayer.prototype.hide = function () {
        this._bottomBarLayout.bottom = -this._bottomBarHeight;
    };
    return ResultLayer;
}(ScillaComponent));
export default ResultLayer;
//# sourceMappingURL=module.js.map