import * as tslib_1 from "tslib";
import { utils, } from "scilla";
import DialogContent from "../popup/DialogContent";
import AnimLayer from "./pkresult/AnimLayer";
import ResultLayer from "./pkresult/ResultLayer";
import globalEvent from "globalEvent";
var PKResult = (function (_super) {
    tslib_1.__extends(PKResult, _super);
    function PKResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResult.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._animLayer = this.AnimLayer.getComponent(AnimLayer);
        this._resultLayer = this.ResultLayer.getComponent(ResultLayer);
    };
    PKResult.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    PKResult.prototype.setup = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.setup.call(this, data);
                        this.AnimLayer.enabled = true;
                        this.ResultLayer.enabled = false;
                        return [4, this._animLayer.play(data)];
                    case 1:
                        _a.sent();
                        return [4, utils.waitPromise(500)];
                    case 2:
                        _a.sent();
                        this.ResultLayer.enabled = true;
                        return [4, this._resultLayer.play(data)];
                    case 3:
                        _a.sent();
                        globalEvent.emit('runCredits');
                        return [2];
                }
            });
        });
    };
    PKResult.prototype.onBottomButtonTap = function (action) {
        this._resultLayer.hide();
        this.hide(action);
    };
    return PKResult;
}(DialogContent));
export default PKResult;
//# sourceMappingURL=module.js.map