import * as tslib_1 from "tslib";
import DialogContent from "../popup/DialogContent";
import TextRenderer from "components/renderer/TextRenderer";
import Transform from "components/base/Transform";
var AlertDialogContent = (function (_super) {
    tslib_1.__extends(AlertDialogContent, _super);
    function AlertDialogContent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AlertDialogContent.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._titleLabel = this.Title.getComponent(TextRenderer);
        this._contentLabel = this.Content.getComponent(TextRenderer);
        this._contentTransform = this.Content.getComponent(Transform);
        if (this.ConfirmButton) {
            this._confirmButtonLabel = this.ConfirmButton.getChildrenByName('Label')[0].getComponent(TextRenderer);
        }
    };
    AlertDialogContent.prototype.setup = function (data) {
        if (data === void 0) { data = {}; }
        var _a = data.title, title = _a === void 0 ? 'Alert' : _a, _b = data.content, content = _b === void 0 ? '' : _b, _c = data.button, button = _c === void 0 ? 'Confirm' : _c, _d = data.showCloseButton, showCloseButton = _d === void 0 ? true : _d;
        this._titleLabel.text = title;
        this._contentLabel.text = content;
        this._closeButton.entity.enabled = showCloseButton;
        if (button) {
            this._confirmButtonLabel.text = button;
        }
        this._contentTransform.position.y = button ? -30 : 40;
        this.ConfirmButton.enabled = !!button;
    };
    AlertDialogContent.prototype.onClickConfirmButton = function () {
        this.hide('confirm');
    };
    return AlertDialogContent;
}(DialogContent));
export default AlertDialogContent;
//# sourceMappingURL=module.js.map