import * as tslib_1 from "tslib";
import { createTween, ease, engine, } from "scilla";
import ScillaComponent from "components/base/ScillaComponent";
import TextRenderer from "components/renderer/TextRenderer";
import Transform from "components/base/Transform";
var Toast = (function (_super) {
    tslib_1.__extends(Toast, _super);
    function Toast() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.padding = 20;
        _this.offsetY = 0;
        _this.showDuration = 300;
        _this.hideDuration = 300;
        return _this;
    }
    Toast.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        var _a = this, offsetY = _a.offsetY, hideDuration = _a.hideDuration, showDuration = _a.showDuration, transform = _a.transform;
        this._bgTransform = this.getComponent(Transform);
        this._labelRenderer = this.Label.getComponent(TextRenderer);
        this._labelTransform = this.Label.getComponent(Transform);
        this._tweenIn = createTween(this, transform, false, { autoPlay: false })
            .to({ position: { x: 0, y: offsetY } }, showDuration, ease.cubicOut);
        this._tweenOut = createTween(this, transform, false, { autoPlay: false })
            .to({ position: { y: 0 } }, hideDuration, ease.cubicIn)
            .call(this.onHidden);
        this.transform.position.y = this.outPos;
    };
    Object.defineProperty(Toast.prototype, "outPos", {
        get: function () {
            return engine.renderContext.stageCenter.y + this._bgTransform.height;
        },
        enumerable: true,
        configurable: true
    });
    Toast.prototype.show = function (_a) {
        var _this = this;
        var content = _a.content, _b = _a.duration, duration = _b === void 0 ? 1000 : _b;
        this.entity.enabled = true;
        var _c = this, _bgTransform = _c._bgTransform, _labelRenderer = _c._labelRenderer, _labelTransform = _c._labelTransform, padding = _c.padding;
        _labelRenderer.text = content;
        _labelRenderer.measureBounds();
        _bgTransform.width = _labelTransform.width + padding * 2;
        _bgTransform.height = _labelTransform.height + padding * 2;
        this._tweenOut.queue[0].props.position.y = this.outPos;
        this._tweenIn.play(true);
        if (this._timerDuration) {
            clearTimeout(this._timerDuration);
            this._timerDuration = null;
        }
        this._timerDuration = setTimeout(function () {
            _this.hide();
        }, duration);
    };
    Toast.prototype.hide = function () {
        this._tweenOut.play(true);
    };
    Toast.prototype.onHidden = function () {
        this.entity.enabled = false;
    };
    return Toast;
}(ScillaComponent));
export default Toast;
//# sourceMappingURL=module.js.map