import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease } from "scilla";
import Transform from "components/base/Transform";
import TextRenderer from "components/renderer/TextRenderer";
export var DIR;
(function (DIR) {
    DIR[DIR["UP"] = 0] = "UP";
    DIR[DIR["DOWN"] = 1] = "DOWN";
})(DIR || (DIR = {}));
var LabelCarousel = (function (_super) {
    tslib_1.__extends(LabelCarousel, _super);
    function LabelCarousel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.offset = 40;
        _this.interval = 1000;
        _this.scrollDuration = 500;
        _this.dir = DIR.UP;
        _this.autoPlay = false;
        _this._playing = false;
        _this._index = 0;
        _this._labels = [];
        return _this;
    }
    LabelCarousel.prototype.onCreate = function () {
        var e_1, _a;
        _super.prototype.onCreate.call(this);
        var _b = this, _labels = _b._labels, entity0 = _b.entity0, entity1 = _b.entity1, offset = _b.offset, dir = _b.dir;
        var entities = [entity0, entity1];
        try {
            for (var entities_1 = tslib_1.__values(entities), entities_1_1 = entities_1.next(); !entities_1_1.done; entities_1_1 = entities_1.next()) {
                var entity = entities_1_1.value;
                var transform = entity.getComponent(Transform);
                var textRenderer = entity.getComponent(TextRenderer);
                transform.position.y = offset * (dir === DIR.UP ? -1 : 1);
                transform.alpha = 0;
                _labels.push({
                    transform: transform,
                    textRenderer: textRenderer
                });
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (entities_1_1 && !entities_1_1.done && (_a = entities_1.return)) _a.call(entities_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (this.autoPlay) {
            this.play();
        }
    };
    LabelCarousel.prototype.play = function () {
        var _this = this;
        this.playNext();
        this.stop();
        this._timer = setInterval(function () {
            _this.playNext();
        }, this.interval);
        this._playing = true;
    };
    LabelCarousel.prototype.stop = function () {
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
        this._playing = false;
    };
    LabelCarousel.prototype.updateText = function (textRenderer) {
        var text = this.getTextFunc ? this.getTextFunc() : null;
        if (text) {
            textRenderer.text = text;
        }
    };
    LabelCarousel.prototype.playNext = function () {
        var _a = this, _labels = _a._labels, _index = _a._index, scrollDuration = _a.scrollDuration, offset = _a.offset, dir = _a.dir;
        var nextLabel = _labels[_index % 2];
        var sign = dir === DIR.UP ? -1 : 1;
        this.updateText(nextLabel.textRenderer);
        createTween(this, nextLabel.transform, true)
            .set({ position: { y: offset * sign * -1 } })
            .to({ position: { y: 0 }, alpha: 1 }, scrollDuration, ease.cubicOut);
        if (_index > 0) {
            var lastLabel = _labels[(_index + 1) % 2];
            createTween(this, lastLabel.transform, true)
                .to({ position: { y: offset * sign }, alpha: 0 }, scrollDuration, ease.cubicOut);
        }
        this._index++;
    };
    return LabelCarousel;
}(ScillaComponent));
export default LabelCarousel;
//# sourceMappingURL=module.js.map