import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease, Vector2D } from "scilla";
import { killTweens } from "scilla/src/support/Tween";
var FloatMissing = (function (_super) {
    tslib_1.__extends(FloatMissing, _super);
    function FloatMissing() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.wait = 500;
        _this.delay = 0;
        _this.endPos = new Vector2D(0, -100);
        _this.onTweenComplete = function () {
            if (_this._tweenResolve) {
                _this._tweenResolve();
                _this._tweenResolve = null;
            }
        };
        return _this;
    }
    FloatMissing.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this.init();
        this._tween = createTween(this, this.transform, false, {
            autoPlay: false,
            initFields: ['position', 'alpha', 'scale'],
            onComplete: this.onTweenComplete
        })
            .wait(this.delay)
            .to({ scale: { x: 1, y: 1 } }, 500, ease.backOut)
            .wait(this.wait)
            .to({ alpha: 0, position: this.endPos.toObj() }, 300);
    };
    FloatMissing.prototype.init = function () {
        this.transform.alpha = 1;
        this.transform.scale.setXY(0, 0);
    };
    FloatMissing.prototype.play = function () {
        var _this = this;
        return new Promise(function (resolve) {
            _this._tweenResolve = resolve;
            _this._tween.play(true, 0, false);
        });
    };
    FloatMissing.prototype.stop = function () {
        killTweens(this.transform);
    };
    return FloatMissing;
}(ScillaComponent));
export default FloatMissing;
//# sourceMappingURL=module.js.map