import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import GraphicRenderer from "components/renderer/GraphicRenderer";
var DotWaiting = (function (_super) {
    tslib_1.__extends(DotWaiting, _super);
    function DotWaiting() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.interval = 300;
        _this._dots = [];
        return _this;
    }
    DotWaiting.prototype.onCreate = function () {
        var e_1, _a;
        _super.prototype.onCreate.call(this);
        this._reset = true;
        this._dots.splice(0);
        try {
            for (var _b = tslib_1.__values(this.entity.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                this._dots.push(child.getComponent(GraphicRenderer));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    DotWaiting.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (this._reset) {
            this._reset = false;
            this._startTime = t;
        }
        var index = Math.floor((t - this._startTime) / this.interval) % this._dots.length;
        if (this._index !== index) {
            for (var i = 0, li = this._dots.length; i < li; i++) {
                var dot = this._dots[i];
                dot.fillColor = index === i ? this.activeColor : this.inativeColor;
            }
        }
    };
    return DotWaiting;
}(ScillaComponent));
export default DotWaiting;
//# sourceMappingURL=module.js.map