import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { ScillaEvent } from "scilla";
import TextureRenderer from "components/renderer/TextureRenderer";
function getTextureNameSample(second) {
    return second + ".png";
}
var CountDown = (function (_super) {
    tslib_1.__extends(CountDown, _super);
    function CountDown() {
        var _this = _super.call(this) || this;
        _this.onComplete = new ScillaEvent();
        _this.interval = 1000;
        _this.hideWhenStop = true;
        _this.onTimer = function () {
            if (_this._remainSeconds <= 0) {
                _this.onComplete.invoke();
                _this.stop();
                return;
            }
            var sheet = _this.numberSheet;
            _this._textureRenderer.texture = sheet.getTexture(_this.$getTextureName(_this._remainSeconds));
            _this._remainSeconds--;
        };
        _this.$getTextureName = getTextureNameSample;
        return _this;
    }
    CountDown.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._textureRenderer = this.getComponent(TextureRenderer);
    };
    CountDown.prototype.play = function () {
        if (this.seconds > 0) {
            this.entity.enabled = true;
            this._remainSeconds = this.seconds;
            this.stop();
            this.onTimer();
            this._timer = setInterval(this.onTimer, this.interval);
        }
    };
    CountDown.prototype.stop = function () {
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
            if (this.hideWhenStop) {
                this.entity.enabled = false;
            }
        }
    };
    return CountDown;
}(ScillaComponent));
export default CountDown;
//# sourceMappingURL=module.js.map