import * as tslib_1 from "tslib";
import { engine, ScillaEvent } from "scilla";
import ScillaComponent from "components/base/ScillaComponent";
export var RequestMethod;
(function (RequestMethod) {
    RequestMethod["GET"] = "GET";
    RequestMethod["POST"] = "POST";
    RequestMethod["PUT"] = "PUT";
    RequestMethod["DELETE"] = "DELETE";
})(RequestMethod || (RequestMethod = {}));
var ApiComponent = (function (_super) {
    tslib_1.__extends(ApiComponent, _super);
    function ApiComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.method = RequestMethod.POST;
        _this.onResponse = new ScillaEvent();
        _this.onError = new ScillaEvent();
        _this.onFinish = new ScillaEvent();
        _this.autoCall = false;
        return _this;
    }
    ApiComponent.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        if (this.autoCall) {
            this.execute();
        }
    };
    ApiComponent.prototype.execute = function (paramsInput) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                this._args = args;
                return [2];
            });
        });
    };
    ApiComponent.prototype.onGotResponse = function (response) {
        var _a;
        if (this.name) {
            engine.dataCenter.set('API', this.name, response.data);
        }
        if (this._args && this._args.length > 0) {
            (_a = this.onResponse).invoke.apply(_a, tslib_1.__spread([response.data], this._args));
        }
        else {
            this.onResponse.invoke(response.data);
        }
        this.onCallFinish();
    };
    ApiComponent.prototype.onGotError = function (e) {
        var _a;
        if (this._args && this._args.length > 0) {
            (_a = this.onError).invoke.apply(_a, tslib_1.__spread([e], this._args));
        }
        else {
            this.onError.invoke(e);
        }
        this.onCallFinish();
    };
    ApiComponent.prototype.onCallFinish = function () {
        var _a;
        if (this._args && this._args.length > 0) {
            (_a = this.onFinish).invoke.apply(_a, tslib_1.__spread(this._args));
        }
        else {
            this.onFinish.invoke();
        }
    };
    return ApiComponent;
}(ScillaComponent));
export default ApiComponent;
//# sourceMappingURL=module.js.map