import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { engine } from "scilla";
import Toast from "./common/Toast";
import Popup from "./popup/Popup";
import { initEnv } from "./common/BuriedPoint";
import { isWeiXin } from "./game/utils";
var MainController = (function (_super) {
    tslib_1.__extends(MainController, _super);
    function MainController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MainController.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        engine.dataCenter.set('CFG', window['CFG']);
        this._toast = this.Toast.getComponent(Toast);
        this._popup = this.Popup.getComponent(Popup);
        initEnv();
        this.broadcast('callApi', 1, 'activityBaseInfo', { opActivityId: this.opActivityId });
    };
    MainController.prototype.onGotActivityBaseInfo = function () {
        this.broadcast('initGameStage');
    };
    MainController.prototype.onActivityBaseInfoError = function (e) {
        console.log(e);
        if (typeof e === 'string') {
            switch (e) {
                case '0100016':
                case '0100014':
                case '0100017':
                    this.showErrorToast(e);
                    break;
                default:
                    this.showNetError();
            }
        }
        else {
            this.showNetError();
        }
    };
    MainController.prototype.showErrorToast = function (e) {
        switch (e) {
            case '0100016':
                this.showToast('活动未开始，暂时无法参与');
                break;
            case '0100014':
            case '0100017':
                this.showToast('活动已结束，无法参与');
                break;
        }
    };
    MainController.prototype.showToast = function (content, duration) {
        this._toast.show({
            content: content,
            duration: duration,
        });
    };
    MainController.prototype.showDialog = function (name, data, callback) {
        this._popup.showDialog(name, data, callback);
    };
    MainController.prototype.hideDialog = function (name, action, data) {
        this._popup.hideDialog(name, action, data);
    };
    MainController.prototype.hideAllDialog = function () {
        this._popup.hideAll();
    };
    MainController.prototype.alert = function (data, callback, callbackDelay) {
        if (callbackDelay === void 0) { callbackDelay = 500; }
        this.showDialog('Alert', data, function (action, data) {
            setTimeout(function () {
                callback(action, data);
            }, callbackDelay);
        });
    };
    MainController.prototype.showLoginAlert = function () {
        var callUpRegistH5Code = engine.dataCenter.get('CFG', 'callUpRegistH5Code');
        var requirelogin = window['requirelogin'];
        var inWeiXin = isWeiXin();
        this.alert({
            title: "\u554A\u54E6\uFF0C\u4F60\u8FD8\u672A\u767B\u5F55",
            content: "\u767B\u5F55\u540E\u5373\u53EF\u53C2\u4E0E\u6D3B\u52A8",
            button: (inWeiXin ? (callUpRegistH5Code || requirelogin) : requirelogin) ? '立即登录' : null,
        }, function (action) {
            if (action === 'confirm') {
                if (inWeiXin) {
                    if (callUpRegistH5Code) {
                        location.href = callUpRegistH5Code;
                    }
                    else if (requirelogin) {
                        requirelogin();
                    }
                    else {
                        console.log('没有登录方案');
                    }
                }
                else {
                    if (requirelogin) {
                        requirelogin();
                    }
                    else {
                        console.log('没有登录方案');
                    }
                }
            }
        });
    };
    MainController.prototype.showCreditsAlert = function () {
        var unitName = engine.dataCenter.get('CFG', 'unitName');
        var earnCreditsUrl = engine.dataCenter.get('CFG', 'earnCreditsUrl');
        this.alert({
            title: "\u554A\u54E6\uFF0C\u5F53\u524D" + unitName + "\u4E0D\u8DB3",
            content: "\u5FEB\u53BB\u9886\u53D6\u66F4\u591A" + unitName + "\u5427",
            button: earnCreditsUrl ? '去做任务' : null,
        }, function (action) {
            if (action === 'confirm') {
                location.href = earnCreditsUrl;
            }
        });
    };
    MainController.prototype.showNetError = function (action) {
        this.showDialog('Alert', { title: '网络异常', content: '请检查网络后重试!', button: '重新加载', showCloseButton: false }, function () {
            if (typeof action === 'function') {
                action();
            }
            else {
                action = action || 'refresh';
                switch (action) {
                    case 'back':
                        history.back();
                        break;
                    case 'refresh':
                        location.reload();
                        break;
                }
            }
        });
    };
    return MainController;
}(ScillaComponent));
export default MainController;
//# sourceMappingURL=module.js.map