/**
 * Created by rockyl on 2019-05-15.
 *
 * 单人挖矿结果
 */

import {createTween, dynamic, Entity, utils} from "scilla";
import DialogContent from "../popup/DialogContent";
import RunNumber from "../common/RunNumber";
import Transform from "components/base/Transform";
import FlySequence from "../common/FlySequence";
import globalEvent from "globalEvent";
import TimesCard from "../game/TimesCard";
import {renderRunCredits} from "../game/utils";

export default class SingleResult extends DialogContent {
	Wrapper: Entity;
	ColorTape: Entity;
	Credits: Entity;
	TimesCard: Entity;
	Light: Entity;
	Coins: Entity;
	singleDigData: dynamic;

	private _runCredits: RunNumber;
	private _timesCard: TimesCard;
	private _wrapperTransform: Transform;
	private _colorTapeTransform: Transform;
	private _lightTransform: Transform;
	private _flySequence: FlySequence;

	onCreate() {
		super.onCreate();

		this._timesCard = this.TimesCard.getComponent(TimesCard);

		this._colorTapeTransform = this.ColorTape.getComponent(Transform);
		this._wrapperTransform = this.Wrapper.getComponent(Transform);
		this._lightTransform = this.Light.getComponent(Transform);
		this._flySequence = this.Coins.getComponent(FlySequence);

		this._runCredits = this.Credits.getComponent(RunNumber);
		this._runCredits.$renderFunc = renderRunCredits;
	}

	onUpdate(t) {
		super.onUpdate(t);
	}

	async setup(data) {
		super.setup(data);


		this.Wrapper.enabled = true;
		this.Light.enabled = false;

		createTween(this, this._wrapperTransform)
			.set({scale: {x: 0.8, y: 0.8}, alpha: 1})
			.to({scale: {x: 1.0, y: 1.0}}, 2000);

		createTween(this, this._colorTapeTransform)
			.set({scale: {x: 0, y: 0}, alpha: 1})
			.wait(100)
			.to({scale: {x: 0.8, y: 0.8}}, 800)
			.to({scale: {x: 1.1, y: 1.1}, alpha: 0}, 1200);

		await this.playCredits();
		this.playLight();
	}

	async playCredits(){
		const {receiveCredits, finalCredits, multipleCard} = this.singleDigData;

		const showTimesCard = multipleCard > 0;
		this.TimesCard.enabled = false;

		await this._runCredits.play(receiveCredits, 0);

		await utils.waitPromise(500);

		if (showTimesCard) {
			this.TimesCard.enabled = true;
			await this._timesCard.playShow(multipleCard);
			createTween(this, this._wrapperTransform)
				.to({scale: {x: 1.2, y: 1.2}}, 2000);
			await this._runCredits.play(finalCredits, receiveCredits);
		}
	}

	private playLight() {
		createTween(this, this._wrapperTransform)
			.to({alpha: 0}, 500)
			.call(()=>{
				this.Wrapper.enabled = false;
			});

		this.Light.enabled = true;
		this._lightTransform.alpha = 0;
		createTween(this, this._lightTransform)
			.set({scale: {x: 0, y: 0}})
			.to({alpha: 1, scale: {x: 1, y: 1}}, 300)
			.call(()=>{
				this.playCoins();
			})
			.to({alpha: 0, scale: {x: 0, y: 0}}, 300)
			.call(()=>{
				this.Light.enabled = false;
			})
	}

	private playCoins() {
		this.bubbling('setBgVisible', false);
		this._flySequence.play();

		globalEvent.emit('runCredits');
	}

	onFlyCoinEnd(){
		this.hide('complete');
	}
}
