/**
 * Created by rockyl on 2019-04-10.
 *
 * 规则对话框内容
 */

import DialogContent from "../popup/DialogContent";
import {dynamic, Entity} from "scilla";
import HtmlRenderer from "components/renderer/HtmlRenderer";

export default class RuleDialogContent extends DialogContent {
	Content: Entity;
	ruleContent: dynamic;

	private _contentRenderer: HtmlRenderer;

	onCreate() {
		super.onCreate();

		this._contentRenderer = this.Content.getComponent(HtmlRenderer);
		this._contentRenderer.htmlText = this.ruleContent;

		const config = window['configJson'];
		this._contentRenderer.color = config.dialog_text_color;
	}
}
