/**
 * Created by rockyl on 2019-05-15.
 *
 * PK挑战书
 */

import DialogContent from "../popup/DialogContent";
import {dynamic, Entity} from "scilla";
import TextRenderer from "components/renderer/TextRenderer";
import {renderRunCredits} from "../game/utils";
import TwoLinesButton from "../game/TwoLinesButton";

export default class PKChallenge extends DialogContent {
	Content: Entity;
	ButtonPK: Entity;
	activityBaseInfo: dynamic;

	private _buttonPK: TwoLinesButton;

	onCreate() {
		super.onCreate();

		this._buttonPK = this.ButtonPK.getComponent(TwoLinesButton);
	}

	setup(data) {
		super.setup(data);

		const {pkExpend, machineNickname} = this.activityBaseInfo;

		this._buttonPK.label1 = renderRunCredits(pkExpend) + '/次';
		this.Content.getComponent(TextRenderer).text = `我是${machineNickname}`;
	}

	onClickConfirm() {
		this.hide('accept')
	}
}
