/**
 * Created by rockyl on 2019-05-08.
 *
 * 浮动上升渐隐
 */

import ScillaComponent from "components/base/ScillaComponent";
import {createTween, ease, Tween, Vector2D} from "scilla";
import {killTweens} from "scilla/src/support/Tween";

export default class FloatMissing extends ScillaComponent {
	wait = 500;
	delay = 0;
	endPos: Vector2D = new Vector2D(0, -100);

	private _tween: Tween;
	private _tweenResolve: Function;

	onAwake() {
		super.onAwake();

		if(!this._tween){
			this.init();
			this._tween = createTween(this, this.transform, false, {
				autoPlay: false,
				initFields: ['position', 'alpha', 'scale'],
				onComplete: this.onTweenComplete
			})
				.wait(this.delay)
				.to({scale: {x: 1, y: 1}}, 500, ease.backOut)
				.wait(this.wait)
				.to({alpha: 0, position: this.endPos.toObj()}, 300);
		}
	}

	init() {
		this.transform.alpha = 1;
		this.transform.scale.setXY(0, 0)
	}

	play() {
		return new Promise(resolve => {
			this._tweenResolve = resolve;
			this._tween.play(true, 0, false);
		})
	}

	stop() {
		killTweens(this.transform);
	}

	private onTweenComplete = () => {
		if (this._tweenResolve) {
			this._tweenResolve();
			this._tweenResolve = null;
		}
	}
}
