/**
 * Created by hwj on 2018/12/1.
 *
 * 简单的api组件
 */

import {utils, } from 'scilla'
import ApiComponent from "./ApiComponent";
import {callApi} from "../net/webService";

export default class SampleApi extends ApiComponent {
	uri: string;
	ignoreSuccessField = false;

	async callApi(name, paramsInput, ...args){
		if(this.name == name){
			await this.execute(paramsInput, ...args);
		}
	}

	protected async execute(paramsInput?, ...args) {
		await super.execute(paramsInput, ...args);

		const params = {};

		if(this.params){
			utils.injectProp(params, this.params);
		}

		if(paramsInput){
			utils.injectProp(params, paramsInput);
		}

		const {uri, method} = this;

		try {
			const response = await callApi(uri, params, method, 'json', this.ignoreSuccessField);

			this.onGotResponse(response);

			return response.data;
		} catch (e) {
			this.onGotError(e);
		}
	}
}
