/**
 * Created by rockyl on 2019-04-29.
 */

const fs = require('fs-extra');
const path = require('path');
const {compile} = require('../src/index');

const projectPath = '/Users/rockyl/.scilla/components';
const inputFile = '/Users/rockyl/.scilla/components/src/renderer/GraphicRenderer/1.0.0/index.ts';

const tsconfigFile = path.join(projectPath, 'tsconfig.json');
const tsconfig = fs.readJsonSync(tsconfigFile);

function test(){
	const declareFile = path.join(path.dirname(inputFile), 'declare.json');
	const outputFile = inputFile.replace('.ts', '.js');

	const declares = fs.readJsonSync(declareFile);
	const externalArr = declares.dependencies.filter(item => !item.startsWith('.'));

	compile(
		inputFile,
		outputFile,
		projectPath,
		'debug',
		null,
		[],
		tsconfig,
		null,
		externalArr
	);
}

test();
