/**
 * Created by rockyl on 2019-04-29.
 */

const path = require('path');
const rollup = require('rollup');
const typescript = require('typescript');
const rpUglify = require('rollup-plugin-uglify');
const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
const rpt = require('./rollup-plugin-typescript.es');
const replace = require('rollup-plugin-replace');

exports.compile = async function(inputFile, outputFile, projectPath, mode, moduleName, includePaths, tsconfig, tslib, externalArr = []) {
	let tsPaths = includePaths ? includePaths.concat() : [];
	let external = ['tslib'].concat(externalArr);

	const pathsConfig = tsconfig.compilerOptions.paths;

	if (pathsConfig) {
		for (let key in pathsConfig) {
			let paths = pathsConfig[key];
			for (let basePath of paths) {
				if (basePath[basePath.length - 1] === '*') {
					basePath += '*/*.ts';
				} else if(key[key.length - 1] === '*'){
					basePath = basePath.replace(/\*\/index$/, '**/*.ts')
				}else{
					try {
						basePath = basePath.replace(/index$/, '**/*.ts')
					} catch (e) {
						console.log(e);
					}
				}
				tsPaths.push(basePath);
			}
		}
	}

	tsPaths = tsPaths.map(item => {
		return path.resolve(projectPath, item);
	});

	//console.log(tsPaths);

	let plugins = [
		resolve({
			browser: true,
		}),
		rpt({
			typescript,
			include: tsPaths,
			tsconfig: tsconfig,
			baseUrl: projectPath,
			removeComments: true,
			tslib,
		}),
		commonjs(),
	];

	if (mode === 'build') {
		plugins.push(rpUglify.uglify({
			//keep_fnames: true,
			//toplevel: true,
			mangle: {
				//properties: true,+
				reserved: [moduleName, 'startup', 'userAgent'],
			}
		}));
		plugins.push(
			replace({
				'DEBUG': JSON.stringify(false),
				'RELEASE': JSON.stringify(true),
			})
		)
	} else {
		plugins.push(
			replace({
				'process.env.NODE_ENV': JSON.stringify('development'),
				'process.env.VUE_ENV': JSON.stringify('browser'),
				'DEBUG': JSON.stringify(true),
				'RELEASE': JSON.stringify(false),
			})
		)
	}

	let writeConfig = {
		file: outputFile,
		format: 'esm',
	};

	if(moduleName){
		writeConfig.format = 'umd';
		writeConfig.name = moduleName;
	}

	if (mode === 'debug') {
		writeConfig.sourcemap = true;
	}

	// create a bundle
	const bundle = await rollup.rollup({
		input: inputFile,
		plugins,
		external,
		onwarn: warning => {
			console.log('warning:', warning);

			//throw new Error(warning);
		}
	})/*.catch(e=>{
		console.log(e);
	})*/;

	// or write the bundle to disk
	await bundle.write(writeConfig);
}
