#!/usr/bin/env node

/**
 * Created by rockyl on 2019-04-26.
 */

const {execute} = require("./cli-wrapper");

const program = require('commander');

program
	.version('1.0.0')
	.description('scilla ts compiler')
	.option('-i, --input [string]', 'input file')
	.option('-p, --projectPath [string]', 'path of project')
	.parse(process.argv);

execute(program).then(
	code=>{
		if(code > 0){
			process.exit(code)
		}
	}
).catch(e=>{
	console.error(e);
	process.exit(99);
});
