/**
 * Created by rockyl on 2019-04-29.
 */

const os = require('os');
const path = require('path');
const fs = require('fs-extra');
const {compile} = require('../src/index');

exports.execute = async function (program) {
	if (!program.input) {
		console.warn('parameter is incorrect');
		return 1;
	}

	const projectPath = program.projectPath || process.cwd();

	const tsconfig = fs.readJsonSync('tsconfig.json');

	const inputFile = program.input;

	const depFile = path.join(path.dirname(inputFile), 'dep.json');
	const outputFile = inputFile.replace('.ts', '.js');

	let externalArr = ['scilla'];
	try {
		const dependencies = fs.readJsonSync(depFile);
		externalArr = externalArr.concat(Object.keys(dependencies).filter(item => !item.startsWith('.')));
	}catch (e) {

	}

	await compile(
		inputFile,
		outputFile,
		projectPath,
		'debug',
		null,
		['src/**/*.ts'],
		tsconfig,
		null,
		externalArr
	);
};
