/**
 * Created by rockyl on 2019-04-29.
 */

const {execute: executeDeclareGenerator} = require('scilla-declare-generator/bin/cli-wrapper');
const {execute: executeTsCompiler} = require('scilla-ts-compiler/bin/cli-wrapper');

const fs = require('fs-extra');
const path = require('path');
const glob = require('glob');

exports.execute = async function (program) {
	const inputFile = program.input;
	if (await fs.exists(inputFile)) {
		const stat = await fs.stat(inputFile);
		if (stat.isDirectory()) {
			const indexFiles = glob.sync(path.join(inputFile, '**/index.ts'));

			let params = {
				projectPath: program.projectPath,
			};
			for (let file of indexFiles) {
				console.log(file);
				params.input = file;
				await executeFile(params);
			}
		} else {
			await executeFile(program);
		}
	}

	return 10
};

async function executeFile(params) {
	let code;
	code = await executeDeclareGenerator(params);
	if (code > 0) {
		return code;
	}
	//return await executeTsCompiler(params);
}
