/**
 * Created by rockyl on 2019-04-29.
 */

const os = require('os');
const path = require('path');
const fs = require('fs-extra');
const {generateDeclareMap} = require('../src/index');

exports.execute = async function (program) {
	if (!program.input) {
		console.warn('parameter is incorrect');
		return 1;
	}

	const componentsPath = program.projectPath || path.join(os.homedir(), '.scilla', 'components');
	const componentsSrcPath = path.join(componentsPath, 'src');
	const tsconfig = fs.readJsonSync(path.join(componentsPath, 'tsconfig.json'));

	const inputFile = program.input;
	const inputFileFolder = path.dirname(inputFile);
	const outputFile = path.join(inputFileFolder, 'declare.json');

	const projectPath = process.cwd();

	function declareFilter(source) {
		return source.fileName.indexOf(inputFileFolder) >= 0;
	}

	const {declareMap, dependencies, missingDependencies} = generateDeclareMap(
		tsconfig,
		inputFile,
		componentsSrcPath,
		projectPath,
		null,
		declareFilter
	);

	if (program.verbose) {
		console.log(result);
	}

	declareMap.dependencies = dependencies;

	if (Object.keys(missingDependencies).length > 0) {
		console.warn(JSON.stringify(missingDependencies, null, '\t'));
		return 2;
	}

	fs.writeJsonSync(outputFile, declareMap);
};
