#!/usr/bin/env node

/**
 * Created by rockyl on 2019-04-26.
 */

const os = require('os');
const path = require('path');
const fs = require('fs-extra');
const program = require('commander');
const {generateDeclareMap} = require('../src/index');

program
	.version('1.0.3')
	.description('scilla declare generator')
	.option('-i, --input [string]', 'input file')
	.option('-o, --output [string]', 'output file')
	.option('-p, --pathofcomponents [string]', 'path of components')
	.option('-v, --verbose [boolean]', 'verbose mode', false)
	.parse(process.argv);

if(!program.input || !program.output){
	console.warn('parameter is incorrect');
	process.exit(1);
}

const componentsPath = program.pathofcomponents || path.join(os.homedir(), '.scilla', 'components');
const componentsSrcPath = path.join(componentsPath, 'src');
const tsconfig = fs.readJsonSync(path.join(componentsPath, 'tsconfig.json'));

const inputFile = program.input;
const inputFileFolder = path.dirname(inputFile);

const projectPath = process.cwd();

function declareFilter(source) {
	return source.fileName.indexOf(inputFileFolder) >= 0;
}

const result = generateDeclareMap(
	tsconfig,
	program.input,
	componentsSrcPath,
	projectPath,
	null,
	declareFilter
);

if(program.verbose){
	console.log(result);
}

if(Object.keys(result.missingDependencies).length > 0){
	console.warn(JSON.stringify(result.missingDependencies, null, '\t'));
	process.exit(2);
}

fs.ensureDirSync(path.dirname(program.output));
fs.writeJsonSync(program.output, result.declareMap);
