/**
 * Created by rockyl on 2019-04-29.
 */

const os = require('os');
const path = require('path');
const fs = require('fs-extra');
const semver = require('semver');
const {generateDeclareMap} = require('../src/index');

function getAllDependencies(dependencies, missingDependencies, componentName, version, componentsSrcPath){
	let temp;
	try {
		temp = fs.readJsonSync(path.join(componentsSrcPath, componentName, version, 'dep.json'));
	}catch (e) {}

	if(temp){
		for(let key in temp){
			if(!dependencies[key]){
				let componentName = key.replace('components/', '');
				let componentPath = path.join(componentsSrcPath, componentName);
				let versions = fs.readdirSync(componentPath);
				versions = versions.filter(item=>item.match(/^\d+\.\d+\.\d+$/));
				let maxVersion = semver.maxSatisfying(versions, temp[key]);
				if(maxVersion){
					dependencies[key] = maxVersion;

					getAllDependencies(dependencies, missingDependencies, componentName, maxVersion, componentsSrcPath);
				}else{
					missingDependencies[key] = temp[key];
				}

			}
		}
	}
}

exports.execute = async function (program) {
	if (!program.input) {
		console.warn('parameter is incorrect');
		return 1;
	}

	const componentsPath = program.projectPath || path.join(os.homedir(), '.scilla', 'components');
	const componentsSrcPath = path.join(componentsPath, 'src');

	const tsconfig = fs.readJsonSync(path.join(componentsPath, 'tsconfig.json'));

	const inputFile = program.input;
	const inputFileFolder = path.dirname(inputFile);
	const outputFile = path.join(inputFileFolder, 'dec.json');

	let componentPath = path.relative(componentsSrcPath, inputFileFolder);
	let componentName = componentPath.substring(0, componentPath.lastIndexOf('/'));
	let componentVersion = componentPath.substr(componentPath.lastIndexOf('/') + 1);
	let dependencies = {}, missingDependenciesPre = {};
	getAllDependencies(dependencies, missingDependenciesPre, componentName, componentVersion, componentsSrcPath);

	let result = dealMissingDependencies(missingDependenciesPre);
	if(result > 0){
		return result;
	}

	const projectPath = process.cwd();

	function declareFilter(source) {
		return source.fileName.indexOf(inputFileFolder) >= 0;
	}

	const {declareMap, missingDependencies} = generateDeclareMap(
		tsconfig,
		dependencies,
		inputFile,
		componentsSrcPath,
		projectPath,
		null,
		declareFilter
	);

	if (program.verbose) {
		console.log(declareMap, missingDependencies);
	}

	result = dealMissingDependencies(missingDependencies);
	if(result > 0){
		return result;
	}

	fs.writeJsonSync(outputFile, declareMap);
};

function dealMissingDependencies(missingDependencies){
	if (Object.keys(missingDependencies).length > 0) {
		console.warn(JSON.stringify(missingDependencies, null, '\t'));
		return 2;
	}
}
