#!/usr/bin/env node

/**
 * Created by rockyl on 2019-04-26.
 */

const os = require('os');
const path = require('path');
const fs = require('fs-extra');
const program = require('commander');
const {generateDeclareMap} = require('../src/index');

program
	.version('1.0.1')
	.description('scilla declare generator')
	.option('-i, --input [string]', 'input file')
	.option('-o, --output [string]', 'output file')
	.parse(process.argv);

const systemComponentsPath = path.join(os.homedir(), '.scilla', 'components');
const systemComponentsSrcPath = path.join(systemComponentsPath, 'src');
const tsconfig = fs.readJsonSync(path.join(systemComponentsPath, 'tsconfig.json'));

const inputFile = program.input;
const inputFileFolder = path.dirname(path.dirname(inputFile));

const projectPath = process.cwd();

function declareFilter(source) {
	return source.fileName.indexOf(inputFileFolder) >= 0;
}

const result = generateDeclareMap(
	tsconfig,
	program.input,
	systemComponentsSrcPath,
	projectPath,
	null,
	declareFilter
);

console.log(result);
