/**
 * Created by rockyl on 2019-08-10.
 */

export async function walkNode(node, callback, includeSelf = false) {
	if (includeSelf) {
		await callback(node, null);
	}
	if (node.children && node.children.length > 0) {
		for (let childNode of node.children) {
			await callback(childNode, node);
			const result = await walkNode(childNode, callback);
			if (result === true) {
				break;
			}
		}
	}
}

export async function walkObject(obj, callback) {
	if(typeof obj === "object"){
		for (let key of Object.keys(obj)) {
			const value = obj[key];
			await callback(key, value, obj);
			const result = await walkObject(value, callback);
			if (result === true) {
				break;
			}
		}
	}
}
