/**
 * Created by rockyl on 2019-08-09.
 */

const PSD = window['require']('psd');

export async function getTree(file) {
	let psd = await PSD.fromDroppedFile(file);

	const root = {};
	walk(psd.tree(), root);

	return root;
}

function walk(psNode, dataNode) {
	const {left: pLeft = 0, top: pTop = 0,} = psNode.parent || {};
	const {left, top, width, height, name, layer: {opacity, visible}} = psNode;
	const x = left - pLeft;
	const y = top - pTop;

	Object.assign(dataNode, {x, y, width, height, alpha: opacity / 255, visible, name, origin: psNode, label: `${name} > [${x}, ${y}, ${width}, ${height}]`});
	if (psNode.children() && psNode.children().length > 0){
		dataNode.children = [];
	}

	let children = psNode.children();
	for (let i = children.length - 1; i >= 0; i--) {
		const childPsNode = children[i];

		const childDataNode = {};
		dataNode.children.push(childDataNode);
		walk(childPsNode, childDataNode)
	}
}
