var Island = require('../world/Island');
var Pool = require('./Pool');

module.exports = IslandPool;

/**
 * @class
 */
function IslandPool() {
	Pool.apply(this, arguments);
}
IslandPool.prototype = new Pool();
IslandPool.prototype.constructor = IslandPool;

/**
 * @method create
 * @return {Island}
 */
IslandPool.prototype.create = function () {
	return new Island();
};

/**
 * @method destroy
 * @param {Island} island
 * @return {IslandPool}
 */
IslandPool.prototype.destroy = function (island) {
	island.reset();
	return this;
};
