/**
 * Created by rockyl on 2021/10/19.
 */

import glob from 'glob'
import fs from 'fs-extra'
import path from 'path'
import {getLinesOfCode, Options} from "./core";

export interface ScanOptions {
	/**后缀名*/
	extNames?: string[]
	/**包含Node模块，默认值:false*/
	includeNodeModules?: boolean
	/**计算配置*/
	options?: Options
}

export async function scan(folder: string, scanOptions: ScanOptions = {}) {
	const {extNames, includeNodeModules, options} = scanOptions

	const pattern = path.join(folder,
		includeNodeModules ? '**/*' : '{,!(node_modules)/**/}*' + (extNames ? extNames.length > 0 ?
			extNames.length == 1 ? `.${extNames[0]}` : `.{${extNames.join(',')}}`
			: '' : ''))
	const files = await new Promise<string[]>((resolve, reject) => {
		glob(pattern, {}, function (err, files) {
			if (err) {
				reject(err)
			} else {
				resolve(files.filter(file => {
					const stat = fs.statSync(file)
					return stat.isFile()
				}))
			}
		})
	})

	const result = await Promise.all(files.map(file => getLinesOfFile(file, options)))
	return {
		num: result.reduce((pv, cv) => {
			return pv + cv
		}, 0),
		fileCount: files.length
	}
}

export async function getLinesOfFile(filePath: string, options?: Options) {
	const content = await fs.readFile(filePath, 'utf-8')
	return getLinesOfCode(content, options)
}
