/**
 * Created by rockyl on 2021/10/19.
 */

const commentStarts = ['//', '/**', '* ', '*/']

export interface Options {
	/**包含注释，默认值:false*/
	includeComments?: boolean
	/**包含空行，默认值:false*/
	includeWhiteLines?: boolean
}

/**
 * 获取代码行数
 * @param code - 代码
 * @param options - 配置参数
 */
export function getLinesOfCode(code: string, options: Options = {}): number {
	const {includeComments = false, includeWhiteLines = false} = options

	const lines = code.split('\n')
	let lineNum = 0
	for (let line of lines) {
		const trimLine = line.trimLeft()
		if (!includeWhiteLines && trimLine.length === 0) {
			continue
		}
		if (!includeComments && commentStarts.filter(starts => trimLine.startsWith(starts)).length > 0) {
			continue
		}
		lineNum++
	}
	return lineNum
}
