#!/usr/bin/env node

/**
 * Created by rockyl on 2021/10/19.
 */
import {program} from 'commander'
import fs from 'fs-extra'
import {scan} from "./scan";

const pkg = fs.readJSONSync('package.json', 'utf-8')

program.version(pkg.version)

program
	.option('-f, --folder <string>', 'folder to scan', process.cwd())
	.option('-n, --includeNodeModules', 'include node_modules', false)
	.option('-c, --includeComments', 'include comment lines', false)
	.option('-w, --includeWhiteLines', 'include white lines', false)
	.option('-e, --extNames <extNames...>', 'ext names, etc: js jsx ts')

program.parse()

const {folder, includeNodeModules, includeComments, includeWhiteLines, extNames} = program.opts();

(async function () {
	const {num, fileCount} = await scan(folder, {
		includeNodeModules,
		extNames,
		options: {includeComments, includeWhiteLines}
	})
	console.log(`结果：扫描到${fileCount}个文件，行数:${num}`)
})()
