# lines-of-code

计算代码行号  
_默认排除注释、空行和node_modules目录的文件_

## Install

`yarn add loc`  
or  
`npm i loc`

## Usage

```js
import {getLinesOfCode} from "loc"

const lines = getLinesOfCode('some codes...')
```

### Api

### 从代码获取代码行数

`getLinesOfCode: (code: string, options?: Options)=>number`

### 从文件获取代码行数

`getLinesOfFile(filePath: string, options?: Options)=>number`

### 扫描文件夹并计算代码行数

`scan(folder: string, scanOptions?: ScanOptions)=>{num: number, fileCount: number}`

### ScanOptions

扫描配置

| 名称 | 类型 | 必须 | 默认值 | 说明 |
| :---- | :---- | :---- | :---- | :---- |
| `extNames` | `string[]` | 否 |  | 后缀名 |
| `includeNodeModules` | `boolean` | 否 | `false` | 包含Node模块 |
| `options` | `Options` | 否 |  | 计算配置 |

### Options

计算配置

| 名称 | 类型 | 必须 | 默认值 | 说明 |
| :---- | :---- | :---- | :---- | :---- |
| `includeComments` | `boolean` | 否 | `false` | 包含注释 |
| `includeWhiteLines` | `boolean` | 否 | `false` | 包含空行 |

## CLI
```shell
> loc --help      
Usage: loc [options]

Options:
  -V, --version                 output the version number
  -f, --folder <string>         folder to scan (default: CWD)
  -n, --includeNodeModules      include node_modules (default: false)
  -c, --includeComments         include comment lines (default: false)
  -w, --includeWhiteLines       include white lines (default: false)
  -e, --extNames <extNames...>  ext names, etc: js jsx ts
  -h, --help                    display help for command

> loc
结果：扫描到22个文件，行数:441

> loc -f src -e ts
结果：扫描到4个文件，行数:84
```
