"use strict";
/**
 * Created by rockyl on 2021/10/19.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLinesOfFile = exports.scan = void 0;
const tslib_1 = require("tslib");
const glob_1 = (0, tslib_1.__importDefault)(require("glob"));
const fs_extra_1 = (0, tslib_1.__importDefault)(require("fs-extra"));
const path_1 = (0, tslib_1.__importDefault)(require("path"));
const core_1 = require("./core");
async function scan(folder, scanOptions = {}) {
    const { extNames, includeNodeModules, options } = scanOptions;
    const pattern = path_1.default.join(folder, includeNodeModules ? '**/*' : '{,!(node_modules)/**/}*' + (extNames ? extNames.length > 0 ?
        extNames.length == 1 ? `.${extNames[0]}` : `.{${extNames.join(',')}}`
        : '' : ''));
    const files = await new Promise((resolve, reject) => {
        (0, glob_1.default)(pattern, {}, function (err, files) {
            if (err) {
                reject(err);
            }
            else {
                resolve(files.filter(file => {
                    const stat = fs_extra_1.default.statSync(file);
                    return stat.isFile();
                }));
            }
        });
    });
    const result = await Promise.all(files.map(file => getLinesOfFile(file, options)));
    return {
        num: result.reduce((pv, cv) => {
            return pv + cv;
        }, 0),
        fileCount: files.length
    };
}
exports.scan = scan;
async function getLinesOfFile(filePath, options) {
    const content = await fs_extra_1.default.readFile(filePath, 'utf-8');
    return (0, core_1.getLinesOfCode)(content, options);
}
exports.getLinesOfFile = getLinesOfFile;
//# sourceMappingURL=scan.js.map