"use strict";
/**
 * Created by rockyl on 2021/10/19.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLinesOfCode = void 0;
const commentStarts = ['//', '/**', '* ', '*/'];
/**
 * 获取代码行数
 * @param code - 代码
 * @param options - 配置参数
 */
function getLinesOfCode(code, options = {}) {
    const { includeComments = false, includeWhiteLines = false } = options;
    const lines = code.split('\n');
    let lineNum = 0;
    for (let line of lines) {
        const trimLine = line.trimLeft();
        if (!includeWhiteLines && trimLine.length === 0) {
            continue;
        }
        if (!includeComments && commentStarts.filter(starts => trimLine.startsWith(starts)).length > 0) {
            continue;
        }
        lineNum++;
    }
    return lineNum;
}
exports.getLinesOfCode = getLinesOfCode;
//# sourceMappingURL=core.js.map