#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/**
 * Created by rockyl on 2021/10/19.
 */
const commander_1 = require("commander");
const fs_extra_1 = (0, tslib_1.__importDefault)(require("fs-extra"));
const scan_1 = require("./scan");
const pkg = fs_extra_1.default.readJSONSync('package.json', 'utf-8');
commander_1.program.version(pkg.version);
commander_1.program
    .option('-f, --folder <string>', 'folder to scan', process.cwd())
    .option('-n, --includeNodeModules', 'include node_modules', false)
    .option('-c, --includeComments', 'include comment lines', false)
    .option('-w, --includeWhiteLines', 'include white lines', false)
    .option('-e, --extNames <extNames...>', 'ext names, etc: js jsx ts');
commander_1.program.parse();
const { folder, includeNodeModules, includeComments, includeWhiteLines, extNames } = commander_1.program.opts();
(async function () {
    const { num, fileCount } = await (0, scan_1.scan)(folder, {
        includeNodeModules,
        extNames,
        options: { includeComments, includeWhiteLines }
    });
    console.log(`结果：扫描到${fileCount}个文件，行数:${num}`);
})();
//# sourceMappingURL=cli.js.map