/**
 * 转换接口数据
 */
interface ICData {
    width: number;
    height: number;
    nodes: INodeData[];
}
/**
 * 节点类型
 */
declare enum NodeType {
    TEXT = 0,
    IMAGE = 1
}
/**
 * 节点数据
 */
interface INodeData {
    type: NodeType;
    x: number;
    y: number;
    width: number;
    height: number;
    src?: string;
    borderRadius?: string;
    img?: HTMLImageElement;
    text?: string;
    color?: string;
    fontSize?: string;
    fontWeight?: string;
    wordWrap?: "break-word" | null;
    textAlign?: "center" | "left" | "right";
}
export interface RenderOptions {
    type?: 'canvas' | 'jpeg' | 'png';
    quality?: number;
}
/**
 * 渲染
 * @param data
 * @param options
 * @param callback
 * @return Promise<HTMLCanvasElement | string>
 */
export declare function toCanvas(data: ICData, options?: RenderOptions, callback?: (canvas: HTMLCanvasElement) => void): Promise<HTMLCanvasElement | string>;
export {};
