/**
 * Created by rockyl on 2021/1/11.
 */

import {parseDom} from "./dom-parser.js";
import {RenderOptions, toCanvas} from "./toCanvas.js";

/**
 * HTML截图
 * @param {HTMLElement} [el] html节点
 * @param options 配置
 * @param {Function} [callback] 回调方法
 * @return Promise<string|HTMLCanvasElement> 如果是字符串则为图片的base64
 */
export function htmlShot(el?: HTMLElement, options?: RenderOptions, callback?: (HTMLCanvasElement) => void): Promise<HTMLCanvasElement | string> {
	return toCanvas(parseDom(el), options, callback)
}
