/**
 * Created by rockyl on 2021/1/11.
 */

const styleKeys = [
	'fontSize',
	'fontFamily',
	'fontWeight',
	'textAlign',
	'color',
	'wordWrap',
	'borderRadius',
]

export function parseDom(el: HTMLElement = document.body) {
	const {left: pX, top: pY, width, height} = el.getBoundingClientRect();

	let nodes = [];
	walkNode(el, function (childNode) {
		let vNode, bound, node;
		if (childNode.nodeName === 'IMG') { //其他全部认为是文本
			node = childNode;
			vNode = {
				type: 1,
				src: childNode.src,
			}
			bound = childNode.getBoundingClientRect();
		} else {
			if (childNode.data) {
				node = childNode.parentElement;
				let text = childNode.data.trim();
				if (text) {  //过滤空文本
					let range = document.createRange();
					range.selectNode(childNode);
					bound = range.getBoundingClientRect();
					range.detach();

					vNode = {
						type: 0,
						text,
					}
				}
			}
		}
		if (vNode) {
			const {left, top, width, height} = bound;
			vNode.x = left - pX;
			vNode.y = top - pY;
			vNode.width = width;
			vNode.height = height;

			let styles = getStylesWithoutDefaults(node);
			for (let skey in styles) {
				if (styleKeys.indexOf(skey) < 0) {
					continue
				}
				vNode[skey] = styles[skey];
			}

			nodes.push(vNode);
		}
	});
	return {
		width,
		height,
		nodes,
	};
}

function walkNode(root, callback) {
	callback(root);

	for (let i = 0, li = root.childNodes.length; i < li; i++) {
		const childNode = root.childNodes[i];
		walkNode(childNode, callback);
	}
}

function getStylesWithoutDefaults(element) {
	let dummy = document.createElement('element-' + (new Date().getTime()));
	document.body.appendChild(dummy);

	let defaultStyles = getComputedStyle(dummy);
	let elementStyles = getComputedStyle(element);

	let diff = {};
	for (let key in elementStyles) {
		if (elementStyles.hasOwnProperty(key)
			&& defaultStyles[key] !== elementStyles[key]) {
			diff[key] = elementStyles[key];
		}
	}

	dummy.remove();

	return diff;
}
