/**
 * Created by rockyl on 2021/1/11.
 */
import {debugMode} from "./config.js"

const commonStyleKeys = [
	'backgroundColor',
	'backgroundImage',
	'borderColor',
	'borderStyle',
	'borderWidth',
]

const styleKeys = [
	'fontFamily',
	'fontSize',
	'fontWeight',
	'textAlign',
	'color',
	'wordWrap',
	'borderRadius',
	'fontStyle',
]

const includeStyleKeys = [
	'fontSize',
]

export function parseDom(el: HTMLElement = document.body) {
	const {left: pX, top: pY, width, height} = el.getBoundingClientRect()

	let nodes = []
	walkNode(el, function (childNode) {
		let vNode, bound, node, isText
		let skip = false
		switch (childNode.nodeName) {
			case 'IMG':
				node = childNode
				const src = node.getAttribute('src')  //必须使用此方法，使用node.src且为空时会返回当前页面链接
				if (src) { //过滤src为空的图片
					vNode = {
						type: 2,
						src,
					}
				}
				break
			case 'CANVAS':
				node = childNode
				vNode = {
					type: 3,
					img: node,
				}
				break
			case '#text':
				isText = true
				node = childNode.parentElement
				let text = childNode.data.trim()
				if (text) {  //过滤空文本
					let range = document.createRange()
					range.selectNode(childNode)
					bound = range.getBoundingClientRect()
					range.detach()

					vNode = {
						type: 1,
						text,
					}
				}
				break
			case '#comment':
				skip = true
				break
			default:

				break
		}
		if (skip) {
			return
		}

		if (!bound && childNode.getBoundingClientRect) {
			bound = childNode.getBoundingClientRect()
		}

		let styles = getStylesWithoutDefaults(node || childNode, includeStyleKeys)
		const asMask = styles.overflow === 'auto' || styles.overflow === 'scroll' || styles.overflow === 'hidden'

		if (!isText) {
			for (let skey of commonStyleKeys) {
				if (commonStyleKeys.indexOf(skey) < 0) {
					continue
				}

				if (!vNode) {
					vNode = {
						type: 0,
					}
				}
				if (styles[skey] !== undefined) {
					vNode[skey] = styles[skey]
				}
			}
		}

		if (vNode && bound) {
			const {left, top, width, height} = bound
			vNode.x = left - pX
			vNode.y = top - pY
			vNode.width = width
			vNode.height = height

			if (asMask) {
				childNode.__vNode = vNode
				vNode.maskBegin = true
			}

			for (let skey in styles) {
				if (styleKeys.indexOf(skey) < 0) {
					continue
				}
				vNode[skey] = styles[skey]
			}

			nodes.push(vNode)
		}
	}, function (childNode) {
		if (childNode.__vNode) {
			const host = childNode.__vNode
			nodes.push({
				type: 0,
				maskEnd: true,
				host,
			})
		}
	})

	if (debugMode) {
		console.info(nodes)
	}

	return {
		width,
		height,
		nodes,
	}
}

function walkNode(root, onEnter, onLeave?) {
	onEnter(root)
	for (let i = 0, li = root.childNodes.length; i < li; i++) {
		const childNode = root.childNodes[i]
		walkNode(childNode, onEnter, onLeave)
	}
	onLeave(root)
}

function getStylesWithoutDefaults(element, includes: string[] = []): any {
	let dummy = document.createElement('element-' + (new Date().getTime()))
	document.body.appendChild(dummy)

	let defaultStyles = getComputedStyle(dummy)
	let elementStyles = getComputedStyle(element)

	let diff = {}
	for (let key in elementStyles) {
		if (includes.indexOf(key) >= 0 || (key in elementStyles && defaultStyles[key] !== elementStyles[key])) {
			diff[key] = elementStyles[key]
		}
	}

	dummy.remove()

	return diff
}
