# HTML截图
实现了HtmlElement的截图功能

## Install
`yarn add html-shot`  
or  
`npm i html-shot`

## Usage
```js
const result = await htmlShot(document.getElementById('poster'));
let img = new Image();
img.src = result;
document.body.appendChild(img);
```

## RenderOptions
| 名称 | 类型 | 必须 | 默认值 | 说明 |
| :---- | :---- | :---- | :---- | :---- |
| `type` | 'canvas' &#124; 'jpeg' &#124; 'png' | 否 | 'png' | 导出类型 |
| `qaulity` | number | 否 | 0.7 | 导出图片质量 |

## 开启调试
```js
window['html-shot/debug-mode'] = true
```

## 注意点
* 仅支持的元素有：`img`、`text`、`canvas(svga/spine/lottie)`
* 不支持`transform`变换
* ~~文本仅只是`Arial`字体，建议给元素设置为`Arial`字体~~
* 1.0.28开始支持自定义字体，前提是确保设备上有字体或者引入了字体
* 不支持`z-index`样式
* 不支持下划线样式
* 不支持所有滤镜
* 不支持文本超出点点点(`ellipsis`)
* 不支持`img`填充样式
* 不支持`overflow`样式
* 不支持跨域的图片
* 换行文本需要加样式：`overflow-wrap: break-word;`
